<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Exam extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'description', 'id_subject', 'code', 'duration_minutes', 'scheduled_at', 'id_school', 'id_grade'];

    protected $casts = [
        // Serialize scheduled_at dengan offset timezone agar parsing konsisten di client
        'scheduled_at' => 'datetime:Y-m-d\\TH:i:sP',
    ];

    public function subject()
    {
        return $this->belongsTo(Subject::class, 'id_subject');
    }

    public function school()
    {
        return $this->belongsTo(School::class, 'id_school');
    }

    public function grade()
    {
        return $this->belongsTo(Grade::class, 'id_grade');
    }
}