<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Carbon\Carbon;

class CheckUserActivity
{
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();

        if ($user) {
            // Waktu idle maksimum (misalnya 30 menit)
            $idleLimit = 5; // dalam menit

            if ($user->last_activity && Carbon::parse($user->last_activity)->lt(now()->subMinutes($idleLimit))) {
                // Sudah idle terlalu lama → hapus token dan last_activity
                $user->tokens()->delete();
                $user->update(['last_activity' => null]);

                return response()->json(['message' => 'Sesi kadaluarsa, silakan login ulang.'], 401);
            }
        }

        return $next($request);
    }
}
