<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolePermissionController extends Controller
{
    public function roles(){ return Role::all(); }
    public function permissions(){ return Permission::all(); }

    // Ambil permissions milik sebuah role
    public function rolePermissions(Role $role){
        return response()->json($role->permissions);
    }

    public function assignPermissionToRole(Request $r){
        $r->validate(['role_id'=>'required','permission_id'=>'required']);
        $role = Role::find($r->role_id);
        $perm = Permission::find($r->permission_id);
        if($role && $perm){ $role->givePermissionTo($perm); return response()->json(['message'=>'OK']); }
        return response()->json(['message'=>'Not found'],404);
    }

    public function revokePermissionFromRole(Request $r){
        $r->validate(['role_id'=>'required','permission_id'=>'required']);
        $role = Role::find($r->role_id);
        $perm = Permission::find($r->permission_id);
        if($role && $perm){ $role->revokePermissionTo($perm); return response()->json(['message'=>'OK']); }
        return response()->json(['message'=>'Not found'],404);
    }

    // Sinkronkan daftar permissions untuk banyak role sekaligus
    public function syncPermissionsForRoles(Request $r){
        $r->validate([
            'roles' => 'required|array',
            'permissions' => 'required|array',
        ]);

        $permissions = Permission::whereIn('id', $r->permissions)->get();
        $roles = Role::whereIn('id', $r->roles)->get();

        foreach ($roles as $role) {
            $role->syncPermissions($permissions);
        }

        return response()->json(['message' => 'Permissions disinkronkan']);
    }
}
