<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Grade;

class GradeController extends Controller
{
    public function index(Request $request)
    {
        $query = Grade::query()->orderBy('grade');
        if ($request->filled('id_school')) {
            $query->where('id_school', (int)$request->input('id_school'));
        }
        return response()->json($query->get());
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'grade' => 'required|integer',
            'id_school' => 'required|exists:schools,id',
        ]);
        $grade = Grade::create($validated);
        return response()->json($grade, 201);
    }

    public function show(Grade $grade)
    {
        return response()->json($grade);
    }

    public function update(Request $request, Grade $grade)
    {
        $validated = $request->validate([
            'grade' => 'required|integer',
            'id_school' => 'required|exists:schools,id',
        ]);
        $grade->update($validated);
        return response()->json($grade);
    }

    public function destroy(Grade $grade)
    {
        $grade->delete();
        return response()->json(['message' => 'Deleted']);
    }
}