<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Auth\AuthenticationException;
use Throwable;

class Handler extends ExceptionHandler
{
    protected $levels = [];
    protected $dontReport = [];
    protected $dontFlash = ['current_password', 'password', 'password_confirmation'];

    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    public function render($request, Throwable $exception)
    {
        // Jika request API (React SPA), kembalikan JSON
        if ($request->is('api/*')) {
            if ($exception instanceof AuthenticationException) {
                return response()->json(['message' => 'Unauthenticated'], 401);
            }

            return response()->json([
                'message' => $exception->getMessage(),
                'type' => get_class($exception),
            ], method_exists($exception, 'getStatusCode') ? $exception->getStatusCode() : 400);
        }

        return parent::render($request, $exception);
    }
}
