<?php
namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\Log;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // Kosongkan file laravel.log tiap pukul 00:00:00 WIB
        $schedule->call(function () {
            try {
                $path = base_path('storage/logs/laravel.log');
                if (is_file($path)) {
                    file_put_contents($path, '');
                }
            } catch (\Throwable $e) {
                Log::error('Failed to clear laravel.log', [
                    'error' => $e->getMessage(),
                ]);
            }
        })->dailyAt('00:00')->timezone('Asia/Jakarta')->name('clear-laravel-log');

        // Jalankan otomatis finalisasi sesi kedaluwarsa tiap menit (opsional via env EXAMS_AUTO_FINALIZE)
        if (env('EXAMS_AUTO_FINALIZE', true)) {
            $schedule->command('exams:finalize-expired --limit=500')
                ->everyMinute()
                ->withoutOverlapping()
                ->name('auto-finalize-expired');
        }
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}