# CRON & flock Setup (Hosting dan Lokal)

Panduan ini menyiapkan cron dan flock agar worker queue tidak tumpang tindih di hosting (cPanel) serta menyediakan padanan perintah untuk pengembangan lokal.

## Prasyarat
- Laravel backend berada di: `/home/learningsqdfsch/backend` (hosting) dan `backend/` (lokal).
- PHP 8.3 di hosting: `/opt/cpanel/ea-php83/root/usr/bin/php`.
- `flock` tersedia di host (umumnya: `/usr/bin/flock`).
- `.env`: `QUEUE_CONNECTION=database` dan tabel `jobs` tersedia.

## Hosting (cPanel)
1. Buat folder locks dan logs:
   - `mkdir -p /home/learningsqdfsch/backend/storage/locks`
   - `chmod 775 /home/learningsqdfsch/backend/storage/locks`
2. Tambahkan baris cron berikut (per menit) di cPanel Cron Jobs:
   - `* * * * * cd /home/learningsqdfsch/backend && /opt/cpanel/ea-php83/root/usr/bin/php artisan schedule:run >> /home/learningsqdfsch/backend/storage/logs/cron-schedule.log 2>&1`
   - `* * * * * cd /home/learningsqdfsch/backend && /usr/bin/flock -n /home/learningsqdfsch/backend/storage/locks/queue.lock /opt/cpanel/ea-php83/root/usr/bin/php artisan queue:work --queue=finalize,autosave --sleep=2 --timeout=120 --tries=3 --stop-when-empty >> /home/learningsqdfsch/backend/storage/logs/cron-queue.log 2>&1`
3. Opsi pemisahan (opsional): jalankan queue `finalize` dan `autosave` pada dua cron berbeda dengan lock file yang berbeda.

## Lokal (Offline)
- Siapkan folder locks/logs:
  - `mkdir -p backend/storage/locks backend/storage/logs`
- Jalankan scheduler dan worker di terminal terpisah:
  - `cd backend && php artisan schedule:work`
  - `cd backend && php artisan queue:work --queue=finalize,autosave --sleep=2 --timeout=120 --tries=3`
- Simulasi flock (opsional):
  - `flock -n backend/storage/locks/queue.lock php artisan queue:work --queue=finalize,autosave --sleep=2 --timeout=120 --tries=3`

## Verifikasi
- Pantau log hosting: `tail -n 100 /home/learningsqdfsch/backend/storage/logs/cron-queue.log`.
- Periksa bahwa proses worker tidak menumpuk setiap menit (flock mencegah duplikasi).
- Periksa `storage/logs/laravel.log` untuk entri:
  - Autosave: `Autosave draft answers` dan tidak muncul jika `finished_at` sudah terisi.
  - Finalisasi: `Exam answers queued submit processed` dan tidak ada duplikasi sesi.

## Troubleshooting
- `flock` tidak ada: gunakan baris cron tanpa `flock` sementara, atau minta penyedia hosting mengaktifkan utilitas tersebut.
- Timeout/tries: sesuaikan `--timeout` dan `--tries` sesuai beban. Default yang disarankan: `--timeout=120`, `--tries=3`.
- Antrian kosong: gunakan `--stop-when-empty` di hosting agar proses selesai dan tidak menggantung.

## Otomatisasi Cepat
Gunakan skrip repo:

```bash
./scripts/setup-cron-flock.sh hosting
# atau
./scripts/setup-cron-flock.sh local
```

Skrip akan membuat folder `storage/locks` dan mencetak baris cron/perintah lokal yang siap dipakai.